/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TournamentGUI
extends JPanel {
    private static Locale locale = new Locale(new String("fi"), new String("FI"));
    private static ResourceBundle messages = ResourceBundle.getBundle("Messages", locale);
    private static ResourceBundle keyCodes = ResourceBundle.getBundle("KeyCodeBundle", locale);
    private static Tournament tournament;
    private static DefaultTableCellRenderer leftRenderer;
    private static DefaultTableCellRenderer centerRenderer;

    TournamentGUI(MainWindow mainWindow, Tournament tournament, File file) {
        TournamentGUI.tournament = tournament;
        this.createThis(mainWindow, file);
    }

    TournamentGUI(MainWindow mainWindow, int n, TreeSet treeSet, File file) {
        SaveTracker.isSaved = false;
        tournament = new Tournament(n, treeSet);
        this.createThis(mainWindow, file);
    }

    private void createThis(MainWindow mainWindow, File file) {
        mainWindow.setTitle(messages.getString("mainWindowHeader"));
        Container container = mainWindow.getContentPane();
        JToolBar jToolBar = this.createToolBar(container, tournament, file);
        container.add((Component)jToolBar, "North");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createLineBorder(Color.black)));
        this.setLayout(new BorderLayout());
        JPanel jPanel = TournamentGUI.createDivisionCards();
        this.add((Component)jPanel, "Center");
        this.add((Component)TournamentGUI.createComboBoxPane(jPanel), "North");
    }

    private JToolBar createToolBar(final Component component, Tournament tournament, File file) {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = null;
        ImageIcon imageIcon = null;
        imageIcon = new ImageIcon(messages.getString("printIconGifFile"));
        jButton = new JButton(messages.getString("mHtmlButton"), imageIcon);
        jButton.setToolTipText(messages.getString("mHtmlToolTip"));
        jButton.setMnemonic((Integer)keyCodes.getObject("mHtmlMnemonic"));
        jButton.addActionListener(new SaveActionListener(file, tournament, 1, component));
        jToolBar.add(jButton);
        imageIcon = new ImageIcon(messages.getString("printIconGifFile"));
        jButton = new JButton(messages.getString("sHtmlButton"), imageIcon);
        jButton.setToolTipText(messages.getString("sHtmlToolTip"));
        jButton.setMnemonic((Integer)keyCodes.getObject("sHtmlMnemonic"));
        jButton.addActionListener(new SaveActionListener(file, tournament, 0, component));
        jToolBar.add(jButton);
        imageIcon = new ImageIcon(messages.getString("printIconGifFile"));
        jButton = new JButton(messages.getString("htmlButton"), imageIcon);
        jButton.setMnemonic((Integer)keyCodes.getObject("htmlMnemonic"));
        jButton.setToolTipText(messages.getString("htmlToolTip"));
        jButton.addActionListener(new SaveActionListener(file, tournament, 3, component));
        jToolBar.add(jButton);
        imageIcon = new ImageIcon(messages.getString("saveAllIconGifFile"));
        jButton = new JButton(messages.getString("saveButton"), imageIcon);
        jButton.setMnemonic((Integer)keyCodes.getObject("saveMnemonic"));
        jButton.setToolTipText(messages.getString("saveToolTip"));
        jButton.addActionListener(new SaveActionListener(file, tournament, 2, component));
        jToolBar.add(jButton);
        imageIcon = new ImageIcon(messages.getString("quitIconGifFile"));
        jButton = new JButton(messages.getString("quitButton"), imageIcon);
        jButton.setToolTipText(messages.getString("quitToolTip"));
        jButton.setMnemonic((Integer)keyCodes.getObject("quitMnemonic"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SaveTracker.isSaved) {
                    System.exit(0);
                }
                Object[] objectArray = new Object[]{messages.getString("doNotQuit"), messages.getString("doQuit")};
                int n = JOptionPane.showOptionDialog(component, messages.getString("areYouSure") + "\n" + messages.getString("youDidNotSave"), messages.getString("reallyQuit"), 0, 3, null, objectArray, objectArray[0]);
                switch (n) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        System.exit(0);
                    }
                }
            }
        });
        jToolBar.add(jButton);
        return jToolBar;
    }

    private static JPanel createComboBoxPane(final JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 3, 4, 3), BorderFactory.createLineBorder(Color.black)), " Valitse lohko: "));
        JComboBox<String> jComboBox = new JComboBox<String>(tournament.getDivisionTitles());
        jComboBox.setEditable(false);
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                cardLayout.show(jPanel, (String)itemEvent.getItem());
            }
        });
        jPanel2.add(jComboBox);
        return jPanel2;
    }

    private static JPanel createMatchListTable(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Division division = tournament.getDivision(n);
        int n2 = 0;
        while (n2 < division.getNumberOfRounds()) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Round round = division.getRound(n2);
            RoundTableModel roundTableModel = new RoundTableModel(round);
            JTable jTable = new JTable(roundTableModel);
            jTable.setShowVerticalLines(false);
            jTable.setShowHorizontalLines(false);
            jTable.setRowSelectionAllowed(false);
            jTable.setColumnSelectionAllowed(false);
            JTableHeader jTableHeader = jTable.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            TournamentGUI.setRoundTableRenderers(jTable.getColumnModel(), n2 + 1);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jTable.getTableHeader(), "North");
            jPanel2.add((Component)jTable, "Center");
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 6, 6, 6), BorderFactory.createLineBorder(Color.black)), "  " + messages.getString("round") + " " + (n2 + 1) + "  "));
            jPanel.add(jPanel2);
            ++n2;
        }
        return jPanel;
    }

    private static void setRoundTableRenderers(TableColumnModel tableColumnModel, int n) {
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(centerRenderer);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMaxWidth(50);
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setPreferredWidth(150);
        tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setCellRenderer(centerRenderer);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMaxWidth(50);
    }

    private static void setSeriesTableRenderers(TableColumnModel tableColumnModel) {
        TableColumn tableColumn;
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setCellRenderer(centerRenderer);
            tableColumn.setPreferredWidth(30);
            tableColumn.setMaxWidth(50);
            ++n;
        }
        tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellRenderer(leftRenderer);
        tableColumn.setPreferredWidth(200);
        tableColumn.setMaxWidth(250);
        tableColumn = tableColumnModel.getColumn(7);
        tableColumn.setPreferredWidth(5);
        tableColumn.setMaxWidth(10);
    }

    private static JPanel createDivisionCards() {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 3, 4, 3), BorderFactory.createLineBorder(Color.black)), " Valittu lohko "));
        jPanel.setLayout(new CardLayout());
        int n = tournament.size();
        JTabbedPane[] jTabbedPaneArray = new JTabbedPane[n];
        int n2 = 0;
        while (n2 < n) {
            jTabbedPaneArray[n2] = new JTabbedPane();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            object = new JScrollPane(TournamentGUI.createMatchListTable(n3), 20, 31);
            ((JComponent)object).setPreferredSize(new Dimension(480, 540));
            jTabbedPaneArray[n3].addTab(messages.getString("matches"), (Component)object);
            JPanel jPanel2 = new JPanel();
            Division division = tournament.getDivision(n3);
            SeriesTableModel seriesTableModel = new SeriesTableModel(division);
            JTable jTable = new JTable(seriesTableModel);
            TournamentGUI.setSeriesTableRenderers(jTable.getColumnModel());
            jTable.setShowVerticalLines(false);
            jTable.setShowHorizontalLines(false);
            jTable.setRowSelectionAllowed(false);
            jTable.setColumnSelectionAllowed(false);
            JTableHeader jTableHeader = jTable.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jTableHeader, "North");
            jPanel2.add((Component)jTable, "Center");
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 6, 6, 6), BorderFactory.createLineBorder(Color.black)), "  " + messages.getString("seriesTable") + " / " + division.getTitle() + "  "));
            jTabbedPaneArray[n3].addTab(messages.getString("seriesTable"), jPanel2);
            jTabbedPaneArray[n3].addChangeListener(new SeriesTableListener(seriesTableModel));
            ++n3;
        }
        object = tournament.getDivisionTitles();
        int n4 = 0;
        while (n4 < n) {
            jPanel.add((Component)jTabbedPaneArray[n4], object[n4]);
            ++n4;
        }
        return jPanel;
    }

    static {
        leftRenderer = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                this.setHorizontalAlignment(2);
                this.setText((String)object);
            }
        };
        centerRenderer = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                this.setHorizontalAlignment(0);
                this.setText((String)object);
            }
        };
    }
}

