/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;

public class Tournament {
    private Locale locale = new Locale(new String("fi"), new String("FI"));
    private ResourceBundle messages = ResourceBundle.getBundle("Messages", this.locale);
    private Vector divisions = new Vector();
    private int numberOfDivisions = 1;
    private static final String date = "x.x.2000";

    private void distributePlayers(TreeSet[] treeSetArray, TreeSet treeSet) {
        int n = 0;
        while (n < treeSetArray.length) {
            treeSetArray[n] = new TreeSet(new PlayerComparator());
            ++n;
        }
        int n2 = 0;
        boolean bl = false;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            treeSetArray[n2].add((Player)iterator.next());
            if (!bl) {
                if (++n2 != treeSetArray.length) continue;
                --n2;
                bl = true;
                continue;
            }
            if (--n2 >= 0) continue;
            ++n2;
            bl = false;
        }
    }

    private int calculateNumberOfDivisions(int n) {
        if (n < 26) {
            return 1;
        }
        if (n < 45) {
            return 2;
        }
        if (n < 60) {
            return 3;
        }
        if (n < 75) {
            return 4;
        }
        if (n < 90) {
            return 5;
        }
        if (n < 105) {
            return 6;
        }
        if (n < 120) {
            return 7;
        }
        return 8;
    }

    Tournament(int n, TreeSet treeSet) {
        this.numberOfDivisions = this.calculateNumberOfDivisions(treeSet.size());
        TreeSet[] treeSetArray = new TreeSet[this.numberOfDivisions];
        this.distributePlayers(treeSetArray, treeSet);
        int n2 = 0;
        while (n2 < this.numberOfDivisions) {
            this.divisions.add(new Division("Lohko " + (n2 + 1), n, treeSetArray[n2]));
            ++n2;
        }
    }

    Tournament(File file) throws IOException, FileFormatException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getName()));
            this.numberOfDivisions = Tools.parseIntAfter("TOURNAMENT-SIZE:", bufferedReader.readLine());
            int n = 0;
            while (n < this.numberOfDivisions) {
                this.divisions.add(new Division(bufferedReader));
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (FileFormatException fileFormatException) {
            throw fileFormatException;
        }
    }

    public int size() {
        return this.numberOfDivisions;
    }

    public int getNumberOfDivisions() {
        return this.numberOfDivisions;
    }

    public Division getDivision(int n) {
        return (Division)this.divisions.elementAt(n);
    }

    public String[] getDivisionTitles() {
        switch (this.numberOfDivisions) {
            case 1: {
                return new String[]{"Agdur"};
            }
            case 2: {
                return new String[]{"Agdur", "Bulldozer"};
            }
            case 3: {
                return new String[]{"A", "B", "C"};
            }
            case 4: {
                return new String[]{"A", "B", "C", "D"};
            }
            case 5: {
                return new String[]{"A", "B", "C", "D", "E"};
            }
            case 6: {
                return new String[]{"A", "B", "C", "D", "E", "F"};
            }
            case 7: {
                return new String[]{"A", "B", "C", "D", "E", "F", "G"};
            }
            case 8: {
                return new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
            }
        }
        return new String[]{"Lohko A"};
    }

    public void save(PrintWriter printWriter, int n) {
        switch (n) {
            case 1: {
                this.saveMatches(printWriter);
                break;
            }
            case 0: {
                this.saveTables(printWriter);
                break;
            }
            case 2: {
                this.save(printWriter);
                break;
            }
            case 3: {
                this.saveAll(printWriter);
                break;
            }
            default: {
                this.save(printWriter);
            }
        }
    }

    public void save(PrintWriter printWriter) {
        printWriter.println("TOURNAMENT-SIZE:" + this.getNumberOfDivisions());
        int n = 0;
        while (n < this.getNumberOfDivisions()) {
            this.getDivision(n).save(printWriter);
            ++n;
        }
    }

    public void saveTables(PrintWriter printWriter) {
        HtmlTools.intro(printWriter, this.messages.getString("seriesTable"));
        HtmlTools.hr(printWriter);
        HtmlTools.br(printWriter);
        int n = 0;
        while (n < this.divisions.size()) {
            this.getDivision(n).saveTable(printWriter);
            ++n;
        }
        HtmlTools.br(printWriter);
        HtmlTools.hr(printWriter);
        HtmlTools.br(printWriter);
        HtmlTools.outro(printWriter);
    }

    public void saveMatches(PrintWriter printWriter) {
        HtmlTools.intro(printWriter, this.messages.getString("matchProgramme"));
        HtmlTools.hr(printWriter);
        int n = 0;
        while (n < this.divisions.size()) {
            this.getDivision(n).saveMatches(printWriter);
            ++n;
        }
        HtmlTools.br(printWriter);
        HtmlTools.hr(printWriter);
        HtmlTools.br(printWriter);
        HtmlTools.outro(printWriter);
    }

    public void saveAll(PrintWriter printWriter) {
        HtmlTools.intro(printWriter, this.messages.getString("seriesTableAndMutualMatches"));
        HtmlTools.insertDate(printWriter, date);
        HtmlTools.hr(printWriter);
        int n = 0;
        while (n < this.getNumberOfDivisions()) {
            this.getDivision(n).saveAll(printWriter);
            HtmlTools.hr(printWriter);
            ++n;
        }
        HtmlTools.outro(printWriter);
    }
}

