/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.table.AbstractTableModel;

public class SeriesTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{"#", "Pelaaja", "O", "V", "T", "H", "tm", "", "pm", "me", "p"};
    private Division division;
    private SeriesTable seriesTable;

    SeriesTableModel(Division division) {
        this.division = division;
        this.seriesTable = division.getSeriesTable();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.seriesTable.size();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        SeriesTableEntry seriesTableEntry = this.seriesTable.elementAt(n);
        switch (n2) {
            case 0: {
                return "" + (n + 1);
            }
            case 1: {
                return seriesTableEntry.getName();
            }
            case 2: {
                return "" + seriesTableEntry.getGames();
            }
            case 3: {
                return "" + seriesTableEntry.getWins();
            }
            case 4: {
                return "" + seriesTableEntry.getTies();
            }
            case 5: {
                return "" + seriesTableEntry.getLosses();
            }
            case 6: {
                return "" + seriesTableEntry.getScored();
            }
            case 7: {
                return "-";
            }
            case 8: {
                return "" + seriesTableEntry.getYielded();
            }
            case 9: {
                return "(" + seriesTableEntry.goalDifference() + ")";
            }
            case 10: {
                return "" + seriesTableEntry.getPoints();
            }
        }
        return "x";
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void update() {
        this.seriesTable = this.division.getSeriesTable();
        this.fireTableDataChanged();
    }
}

