/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;

public class SeriesTableEntry {
    private String playerName;
    private int wins = 0;
    private int ties = 0;
    private int losses = 0;
    private int goalsScored = 0;
    private int goalsYielded = 0;

    SeriesTableEntry(String string) {
        this.playerName = string;
    }

    public String getName() {
        return this.playerName;
    }

    public int getGames() {
        return this.wins + this.ties + this.losses;
    }

    public int getWins() {
        return this.wins;
    }

    public int getTies() {
        return this.ties;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getScored() {
        return this.goalsScored;
    }

    public int getYielded() {
        return this.goalsYielded;
    }

    public int getPoints() {
        return 2 * this.wins + this.ties;
    }

    public void increaseWins() {
        ++this.wins;
    }

    public void increaseTies() {
        ++this.ties;
    }

    public void increaseLosses() {
        ++this.losses;
    }

    public void score(int n) {
        this.goalsScored += n;
    }

    public void yield(int n) {
        this.goalsYielded += n;
    }

    public void decreaseWins() {
        --this.wins;
    }

    public void decreaseTies() {
        --this.ties;
    }

    public void decreaseLosses() {
        --this.losses;
    }

    public void unscore(int n) {
        this.goalsScored -= n;
    }

    public void unyield(int n) {
        this.goalsYielded -= n;
    }

    public int goalDifference() {
        return this.goalsScored - this.goalsYielded;
    }

    public String getHtmlTableRow() {
        String string = HtmlTools.td(this.getName()) + HtmlTools.td(this.getGames()) + HtmlTools.td(this.getWins()) + HtmlTools.td(this.getTies()) + HtmlTools.td(this.getLosses()) + HtmlTools.td(this.getScored()) + HtmlTools.td("-") + HtmlTools.td(this.getYielded()) + HtmlTools.td(this.getPoints());
        return HtmlTools.tr(string);
    }

    public String getRow() {
        return Tools.format(this.playerName, 24) + Tools.format(this.getGames(), 3) + Tools.format(this.getWins(), 3) + Tools.format(this.getTies(), 3) + Tools.format(this.getLosses(), 3) + Tools.format(this.getScored(), 4) + "-" + Tools.format(this.getYielded() + "", 3) + Tools.format(this.getPoints(), 4);
    }

    public void print(PrintWriter printWriter) {
        printWriter.println(this.getRow());
    }

    public void print() {
        System.out.println(this.getRow());
    }

    public void updateWith(Match match) {
        if (!match.isOver()) {
            return;
        }
        if (this.playerName.equals(match.home())) {
            this.score(match.homeGoals());
            this.yield(match.visitorGoals());
            if (match.homeGoals() > match.visitorGoals()) {
                this.increaseWins();
                return;
            }
            if (match.homeGoals() < match.visitorGoals()) {
                this.increaseLosses();
                return;
            }
            this.increaseTies();
            return;
        }
        if (this.playerName.equals(match.visitor())) {
            this.score(match.visitorGoals());
            this.yield(match.homeGoals());
            if (match.homeGoals() > match.visitorGoals()) {
                this.increaseLosses();
                return;
            }
            if (match.homeGoals() < match.visitorGoals()) {
                this.increaseWins();
                return;
            }
            this.increaseTies();
            return;
        }
    }

    public void cancelMatch(Match match) {
        if (!match.isOver()) {
            return;
        }
        if (this.playerName.equals(match.home())) {
            this.unscore(match.homeGoals());
            this.unyield(match.visitorGoals());
            if (match.homeGoals() > match.visitorGoals()) {
                this.decreaseWins();
                return;
            }
            if (match.homeGoals() < match.visitorGoals()) {
                this.decreaseLosses();
                return;
            }
            this.decreaseTies();
            return;
        }
        if (this.playerName.equals(match.visitor())) {
            this.unscore(match.visitorGoals());
            this.unyield(match.homeGoals());
            if (match.homeGoals() > match.visitorGoals()) {
                this.decreaseLosses();
                return;
            }
            if (match.homeGoals() < match.visitorGoals()) {
                this.decreaseWins();
                return;
            }
            this.decreaseTies();
            return;
        }
    }
}

