/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class SeriesTable {
    private SeriesTableEntry[] table;

    SeriesTable(Hashtable hashtable) {
        TreeSet<SeriesTableEntry> treeSet = new TreeSet<SeriesTableEntry>(new SeriesTableEntryComparator());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            SeriesTableEntry seriesTableEntry = (SeriesTableEntry)enumeration.nextElement();
            treeSet.add(seriesTableEntry);
        }
        this.table = new SeriesTableEntry[treeSet.size()];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            this.table[n++] = (SeriesTableEntry)iterator.next();
        }
    }

    public int size() {
        return this.table.length;
    }

    public SeriesTableEntry elementAt(int n) {
        return this.table[n];
    }

    public void htmlSave(PrintWriter printWriter) {
        HtmlTools.tableIntro(printWriter, false, "100%");
        int n = 0;
        while (n < this.size()) {
            printWriter.println(this.elementAt(n).getHtmlTableRow());
            ++n;
        }
        HtmlTools.tableOutro(printWriter);
    }

    public void print(PrintWriter printWriter) {
        int n = 0;
        while (n < this.size()) {
            printWriter.println(Tools.format(n + 1, 4) + " " + this.elementAt(n).getRow() + "  ");
            ++n;
        }
    }
}

