/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;

public class Round {
    private Locale locale = new Locale(new String("fi"), new String("FI"));
    private ResourceBundle messages = ResourceBundle.getBundle("Messages", this.locale);
    private Division mother;
    private int number;
    private String pausePlayer;
    private Match[] matches;
    private int numberOfMatches;

    Round(Division division, int n, String[] stringArray) {
        this.mother = division;
        this.number = n;
        this.pausePlayer = stringArray[0];
        this.numberOfMatches = stringArray.length / 2;
        this.matches = new Match[this.numberOfMatches];
        try {
            int n2 = 1;
            while (n2 <= this.numberOfMatches) {
                this.matches[n2 - 1] = new Match(stringArray[n2] + ':' + stringArray[stringArray.length - n2]);
                ++n2;
            }
        }
        catch (FileFormatException fileFormatException) {
            // empty catch block
        }
    }

    Round(Division division, int n, BufferedReader bufferedReader) throws FileFormatException, IOException {
        this.mother = division;
        this.numberOfMatches = n;
        this.matches = new Match[n];
        try {
            this.number = Tools.parseIntAfter("ROUND:", bufferedReader.readLine());
            String string = bufferedReader.readLine();
            if (!string.startsWith("(")) {
                throw new FileFormatException();
            }
            this.pausePlayer = string.substring(1, string.length() - 1);
            int n2 = 0;
            while (n2 < n) {
                Match match;
                this.matches[n2] = match = new Match(bufferedReader.readLine());
                if (!match.isDummy()) {
                    division.getMutual().insert(match);
                    division.getSeriesTableEntry(match.home()).updateWith(match);
                    division.getSeriesTableEntry(match.visitor()).updateWith(match);
                }
                ++n2;
            }
            if (!bufferedReader.readLine().equals("END-OF-ROUND")) {
                throw new FileFormatException();
            }
        }
        catch (FileFormatException fileFormatException) {
            throw fileFormatException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public Match getMatch(int n) {
        return this.matches[n];
    }

    public void print() {
        System.out.println("\nRound " + this.number);
        System.out.println(this.messages.getString("pause") + ": " + this.pausePlayer);
        int n = 0;
        while (n < this.numberOfMatches) {
            this.matches[n].print();
            ++n;
        }
    }

    public void save(PrintWriter printWriter) {
        printWriter.println("ROUND:" + this.getNumber());
        printWriter.println("(" + this.pausePlayer + ")");
        int n = 0;
        while (n < this.getNumberOfMatches()) {
            this.getMatch(n).save(printWriter);
            ++n;
        }
        printWriter.println("END-OF-ROUND");
    }

    public void saveMatches(PrintWriter printWriter) {
        HtmlTools.tableIntro(printWriter, false);
        printWriter.println("<TR><TH COLSPAN=8>" + this.mother.getTitle() + " / " + this.messages.getString("round") + " " + this.number + "</TH></TR>");
        printWriter.println("<TR>");
        HtmlTools.td(printWriter, "0");
        HtmlTools.td(printWriter, ":");
        HtmlTools.td(printWriter, "<EM>" + this.messages.getString("pause") + ":</EM>");
        HtmlTools.td(printWriter, "&nbsp;");
        HtmlTools.td(printWriter, this.pausePlayer, 4);
        printWriter.println("</TR>");
        int n = 0;
        while (n < this.numberOfMatches) {
            printWriter.println(this.matches[n].getHtmlTableRow(n + 1));
            ++n;
        }
        HtmlTools.tableOutro(printWriter);
    }

    public String getPausePlayer() {
        return this.pausePlayer;
    }

    public int getNumber() {
        return this.number;
    }

    public int getNumberOfMatches() {
        return this.numberOfMatches;
    }

    public Division getDivision() {
        return this.mother;
    }
}

