/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class RegistrationGUI
extends JPanel {
    private Locale locale = new Locale(new String("fi"), new String("FI"));
    private ResourceBundle messages = ResourceBundle.getBundle("Messages", this.locale);
    private MainWindow mainWindow;
    private Container mainWindowContents;
    private static TreeSet names = new TreeSet(new PlayerCheckBoxComparator());
    private int counter = 0;
    private int rank = 0;

    private void popUpErrorMessage(String string) {
        JOptionPane.showMessageDialog(this, string, this.messages.getString("duplicateErrorMessageHeader"), 2, null);
    }

    private static String fixName(String string) {
        String string2 = string.trim();
        int n = string2.indexOf(32);
        if (n < 0) {
            return RegistrationGUI.capitalize(string2.trim());
        }
        String string3 = string2.substring(0, n).trim();
        String string4 = string2.substring(n + 1).trim();
        return RegistrationGUI.capitalize(string3) + " " + RegistrationGUI.capitalize(string4);
    }

    private static String capitalize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.toLowerCase());
        stringBuffer.replace(0, 1, string.substring(0, 1).toUpperCase());
        int n = string.indexOf(45);
        if (n > 0) {
            stringBuffer = stringBuffer.replace(n + 1, n + 2, string.substring(n + 1, n + 2).toUpperCase());
        }
        return stringBuffer.toString();
    }

    RegistrationGUI(MainWindow mainWindow, File file, File file2) {
        super(new BorderLayout());
        JToggleButton jToggleButton;
        Object object;
        this.mainWindow = mainWindow;
        this.mainWindowContents = mainWindow.getContentPane();
        this.mainWindow.setTitle(this.messages.getString("registrationWindowHeader"));
        final JLabel jLabel = new JLabel("0");
        final JLabel jLabel2 = new JLabel(" " + this.messages.getString("players"));
        final ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    --RegistrationGUI.this.counter;
                } else {
                    ++RegistrationGUI.this.counter;
                }
                jLabel.setText(RegistrationGUI.this.counter + " ");
                jLabel2.setText(RegistrationGUI.this.counter == 1 ? RegistrationGUI.this.messages.getString("player") : RegistrationGUI.this.messages.getString("players"));
            }
        };
        LineReader lineReader = new LineReader(file.getName());
        while (lineReader.hasNext()) {
            object = RegistrationGUI.fixName((String)lineReader.next());
            jToggleButton = new PlayerJCheckBox(++this.rank, (String)object);
            jToggleButton.addItemListener(itemListener);
            if (names.contains(jToggleButton)) {
                this.popUpErrorMessage((String)object + " " + this.messages.getString("moreThanOnce") + " " + file.getName() + ".");
                continue;
            }
            names.add(jToggleButton);
        }
        object = new JRadioButton("1");
        ((AbstractButton)object).setActionCommand("1");
        ((AbstractButton)object).setSelected(true);
        jToggleButton = new JRadioButton("2");
        jToggleButton.setActionCommand("2");
        jToggleButton.setSelected(true);
        JRadioButton jRadioButton = new JRadioButton("3");
        jRadioButton.setActionCommand("3");
        jRadioButton.setSelected(true);
        JRadioButton jRadioButton2 = new JRadioButton("4");
        jRadioButton2.setActionCommand("4");
        jRadioButton2.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)object);
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        RadioListener radioListener = new RadioListener();
        ((AbstractButton)object).addActionListener(radioListener);
        jToggleButton.addActionListener(radioListener);
        jRadioButton.addActionListener(radioListener);
        jRadioButton2.addActionListener(radioListener);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 30, 15, 30));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel(this.messages.getString("choosePlayers")));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel(this.messages.getString("rounds") + ":"));
        jPanel.add(Box.createRigidArea(new Dimension(30, 0)));
        jPanel.add((Component)object);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jToggleButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jRadioButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jRadioButton2);
        final JPanel jPanel2 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(15, 30, 15, 30);
        jPanel2.setBorder(border);
        jPanel2.setLayout(new GridLayout(0, 4, 10, 5));
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            jPanel2.add((PlayerJCheckBox)iterator.next());
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel2, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(200, 350));
        final JTextField jTextField = new JTextField(30);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = RegistrationGUI.fixName(jTextField.getText());
                jTextField.setText("");
                if (string.equals("")) {
                    return;
                }
                PlayerJCheckBox playerJCheckBox = new PlayerJCheckBox(++RegistrationGUI.this.rank, string, true);
                if (names.contains(playerJCheckBox)) {
                    RegistrationGUI.this.popUpErrorMessage(string + " " + RegistrationGUI.this.messages.getString("duplicateEntry") + ".");
                } else {
                    playerJCheckBox.addItemListener(itemListener);
                    names.add(playerJCheckBox);
                    jLabel.setText(++RegistrationGUI.this.counter + " ");
                    jLabel2.setText(RegistrationGUI.this.counter == 1 ? RegistrationGUI.this.messages.getString("player") : RegistrationGUI.this.messages.getString("players"));
                    jPanel2.add(playerJCheckBox);
                    jPanel2.revalidate();
                    jPanel2.repaint();
                }
            }
        });
        JButton jButton = new JButton(this.messages.getString("readyButton"));
        jButton.setToolTipText(this.messages.getString("readyToolTip"));
        jButton.addActionListener(new ReadyActionListener(this.mainWindow, names, file2, radioListener));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 30, 15, 30));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(new JLabel(this.messages.getString("newPlayerPrompt")));
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jTextField);
        jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel3.add(new JLabel(this.messages.getString("totalOf") + " "));
        jPanel3.add(jLabel);
        jPanel3.add(jLabel2);
        jPanel3.add(Box.createRigidArea(new Dimension(20, 0)));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel3, "South");
    }
}

