/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class Division {
    private String title;
    private TreeSet players;
    private Mutual mutual;
    private int numberOfPlayers;
    private Hashtable seriesTableEntries = new Hashtable();
    private boolean hasDummyPlayer = false;
    private String[] seats;
    private int times;
    private Round[] rounds;

    private void makeInitialSeating() {
        int n = 0;
        Iterator iterator = this.players.iterator();
        while (iterator.hasNext()) {
            this.seats[n++] = ((Player)iterator.next()).getName();
        }
        if (this.hasDummyPlayer) {
            this.seats[n] = this.seats[1];
            this.seats[1] = "X";
        }
    }

    private void makeNextSeating() {
        String string = this.seats[this.seats.length - 1];
        int n = this.seats.length - 1;
        while (n > 0) {
            this.seats[n] = this.seats[n - 1];
            --n;
        }
        this.seats[0] = string;
    }

    private void printSeating() {
        int n = 0;
        while (n < this.seats.length) {
            System.out.println("Paikka " + n + ": " + this.seats[n]);
            ++n;
        }
    }

    private void buildAllRounds() {
        this.makeInitialSeating();
        int n = 0;
        while (n < this.rounds.length) {
            this.rounds[n] = new Round(this, n + 1, this.seats);
            this.makeNextSeating();
            ++n;
        }
    }

    private void printAllRounds() {
        int n = 0;
        while (n < this.seats.length) {
            this.rounds[n].print();
            ++n;
        }
    }

    Division(String string, int n, TreeSet treeSet) {
        this.title = string;
        this.times = n;
        this.players = treeSet;
        this.mutual = new Mutual(treeSet);
        this.numberOfPlayers = treeSet.size();
        this.hasDummyPlayer = treeSet.size() % 2 == 0;
        this.buildSeriesTableEntries(this.players);
        int n2 = this.hasDummyPlayer ? treeSet.size() + 1 : treeSet.size();
        this.rounds = new Round[n2 * n];
        this.seats = new String[n2];
        this.buildAllRounds();
    }

    Division(BufferedReader bufferedReader) throws FileFormatException, IOException {
        try {
            int n;
            this.title = Tools.parseStringAfter("DIVISION:", bufferedReader.readLine());
            this.numberOfPlayers = n = Tools.parseIntAfter("PLAYERS:", bufferedReader.readLine());
            this.players = new TreeSet(new PlayerComparator());
            int n2 = 0;
            while (n2 < n) {
                this.players.add(new Player(n2 + 1, bufferedReader.readLine()));
                ++n2;
            }
            if (!bufferedReader.readLine().equals("END-OF-PLAYERS")) {
                throw new FileFormatException();
            }
            this.hasDummyPlayer = n % 2 == 0;
            this.mutual = new Mutual(this.players);
            this.buildSeriesTableEntries(this.players);
            int n3 = Tools.parseIntAfter("ROUNDS:", bufferedReader.readLine());
            this.rounds = new Round[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.rounds[n4] = new Round(this, n / 2, bufferedReader);
                ++n4;
            }
            if (!bufferedReader.readLine().equals("END-OF-DIVISION")) {
                throw new FileFormatException();
            }
        }
        catch (FileFormatException fileFormatException) {
            throw fileFormatException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private void buildSeriesTableEntries(TreeSet treeSet) {
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = ((Player)iterator.next()).getName();
            this.seriesTableEntries.put(string, new SeriesTableEntry(string));
        }
    }

    public Mutual getMutual() {
        return this.mutual;
    }

    public String getTitle() {
        return this.title;
    }

    public int getNumberOfPlayers() {
        return this.players.size();
    }

    public int getNumberOfRounds() {
        return this.rounds.length;
    }

    public Round getRound(int n) {
        return this.rounds[n];
    }

    public SeriesTableEntry getSeriesTableEntry(String string) {
        return (SeriesTableEntry)this.seriesTableEntries.get(string);
    }

    public SeriesTable getSeriesTable() {
        return new SeriesTable(this.seriesTableEntries);
    }

    public void save(PrintWriter printWriter) {
        printWriter.println("DIVISION:" + this.getTitle());
        printWriter.println("PLAYERS:" + this.numberOfPlayers);
        Iterator iterator = this.players.iterator();
        while (iterator.hasNext()) {
            printWriter.println(((Player)iterator.next()).getName());
        }
        printWriter.println("END-OF-PLAYERS");
        printWriter.println("ROUNDS:" + this.getNumberOfRounds());
        int n = 0;
        while (n < this.getNumberOfRounds()) {
            this.getRound(n).save(printWriter);
            ++n;
        }
        printWriter.println("END-OF-DIVISION");
    }

    public void saveAll(PrintWriter printWriter) {
        SeriesTable seriesTable = this.getSeriesTable();
        printWriter.println("<table align=center bgcolor=\"#c0c0c0\">");
        printWriter.println("<tr>\n<td>\n<pre>\n");
        seriesTable.print(printWriter);
        printWriter.println("</pre>\n</td>\n</tr>\n</table>\n<p>");
        printWriter.println("<table width=\"100%\" border=1>");
        printWriter.println("<tr><th align=center>Keskin\u00e4iset ottelut</th>");
        int n = 0;
        while (n < seriesTable.size()) {
            String string = seriesTable.elementAt(n).getName();
            printWriter.println("\t<td align=center>" + Tools.makeInitials(string) + "</td>");
            ++n;
        }
        printWriter.println("</tr>");
        int n2 = 0;
        while (n2 < seriesTable.size()) {
            SeriesTableEntry seriesTableEntry = seriesTable.elementAt(n2);
            String string = seriesTableEntry.getName();
            printWriter.println("<tr><td>" + string + "</td>");
            int n3 = 0;
            while (n3 < seriesTable.size()) {
                if (n2 == n3) {
                    printWriter.println("<td>&nbsp;</td>");
                } else {
                    SeriesTableEntry seriesTableEntry2 = seriesTable.elementAt(n3);
                    String string2 = seriesTableEntry2.getName();
                    printWriter.println("\t<td align=center> " + this.mutual.getResult(string, string2) + "</td>");
                }
                ++n3;
            }
            printWriter.println("</tr>");
            ++n2;
        }
        printWriter.println("</table>");
    }

    public void saveTable(PrintWriter printWriter) {
        HtmlTools.h1(printWriter, this.getTitle());
        this.getSeriesTable().htmlSave(printWriter);
    }

    public void saveMatches(PrintWriter printWriter) {
        HtmlTools.tableIntro(printWriter, true, "100%");
        int n = 0;
        while (n < this.getNumberOfRounds() - 1) {
            printWriter.println("<TR><TD>");
            this.getRound(n).saveMatches(printWriter);
            printWriter.println("</TD>");
            printWriter.println("<TD ALIGN=RIGHT>");
            this.getRound(n + 1).saveMatches(printWriter);
            printWriter.println("</TD></TR>");
            n += 2;
        }
        printWriter.println("<TR><TD>");
        this.getRound(this.getNumberOfRounds() - 1).saveMatches(printWriter);
        printWriter.println("</TD></TR>");
        HtmlTools.tableOutro(printWriter);
    }
}

